#include <iostream>
#include <unordered_map>
#include <cmath>
#include <vector>
#include <map>
#include <algorithm>
#include <string>
#include <queue>
#include <fstream>
#include <random>
#include <stack>

using namespace std;


std::vector<std::vector<bool>> visited;
//std::vector<std::vector<char>> arr;
// age, pos
#define yx std::pair<int, int>
#define fire std::pair<int, yx>
#define fireQueue std::priority_queue<fire, std::vector<fire>, std::greater<fire>>

int res = 0;

void iterateFire(fireQueue& queue) {
    if (queue.empty()) return;
    int currAge = queue.top().first;
    while (!queue.empty() && queue.top().first == currAge) {
        yx pos = queue.top().second;
        int di[] = { -1, 0, 0, 1 };
        int dj[] = { 0, 1, -1, 0 };
        queue.pop();
        for (int k = 0; k < 4; k++) {
            int i = di[k] + pos.first;
            int j = dj[k] + pos.second;
            if (i >= 0 && i < visited.size() && j >= 0 && j < visited[0].size()) {
                if (!visited[i][j]) {
                    queue.push({ currAge + 1, {i, j} });
                    visited[i][j] = true;
                }
            }
        }
    }
}

void iterateMain(fireQueue& queue) {
    if (queue.empty()) return;
    int currAge = queue.top().first;
    while (!queue.empty() && queue.top().first == currAge) {
        yx pos = queue.top().second;
        int di[] = { -1, 0, 0, 1 };
        int dj[] = { 0, 1, -1, 0 };
        queue.pop();
        for (int k = 0; k < 4; k++) {
            int i = di[k] + pos.first;
            int j = dj[k] + pos.second;
            if (i >= 0 && i < visited.size() && j >= 0 && j < visited[0].size()) {
                if (!visited[i][j]) {
                    queue.push({ currAge + 1, {i, j} });
                    visited[i][j] = true;
                    res += 1;
                }
            }
        }
    }
}

struct Node {
    Node* one;
    Node* zero;
    Node() : one(NULL), zero(NULL) {}
};

void insert(int n, Node* root) {
    Node* tree = root;
    for (int i = 31; i >= 0; i--) {
        int c = (n >> i) & 1;
        if (c == 0) {
            if (tree->zero == nullptr) {
                tree->zero = new Node();
            }
            tree = tree->zero;
        }
        else {
            if (tree->one == nullptr) {
                tree->one = new Node();
            }
            tree = tree->one;
        }
    }
}

int eval(int k, Node* root) {
    Node* tree = root;
    int curr = 0;

    for (int i = 31; i >= 0; i--) {
        int c = (k >> i) & 1;
        if (c == 0) {
            if (tree->one) {
                tree = tree->one;
                curr += (1 << i);
            }
            else {
                tree = tree->zero;
            }
        }
        else {
            if (tree->zero) {
                tree = tree->zero;
                curr += (1 << i);
            }
            else {
                tree = tree->one;
            }
        }
    }
    return curr;
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);

    /*int t;
    std::cin >> t;
    for (int iter = 0; iter < t; iter++) {
        long long l, r, k;
        std::cin >> l >> r >> k;
        
        long long p = r / k;
        long long res = (p - l + 1);
        if (res < 0) res = 0;
        std::cout << res << std::endl;
        
    }*/

    int n;
    std::cin >> n;
    Node* root = new Node();

    std::vector<long long> prefix(n), a(n), b(n);
    for (int i = 0; i < n; i++) {
        std::cin >> a[i];
        if (i == 0) {
            prefix[i] = a[i];
        }
        else {
            prefix[i] = prefix[i - 1] ^ a[i];
        }
    }
    for (int i = 0; i < n; i++) {
        std::cin >> b[i];
    }
    int res = 0;
    insert(prefix[0], root);
    for (int i = 1; i < n; i++) {
        res = std::max(eval(prefix[i], root), res);
        insert(prefix[i], root);
    }
    std::cout << res << std::endl;;

    return 0;
}